//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef GPUMATRIX_H_
#define GPUMATRIX_H_

#include <iostream>


namespace Go {
    
    template <typename T>
    class GpuMatrix {
        public:
        /**
         * Constructs a matrix on the GPU
         */
        GpuMatrix(int rows, int cols);
        
        /**
         * Constructs a matrix on the GPU using data as initial values
         */
        GpuMatrix(int rows, int cols, T* data);
        
        /**
         * Constructs a matrix on the GPU setting all values to initializer.
         */
        GpuMatrix(int rows, int cols, T initializer);
        
        /**
         * Deletes data allocated on the gpu.
         */
        ~GpuMatrix();
      
        /**
         * Uploads data from cpu memory to gpu memory. Using "pinned memory"
         * will give best performance.
         */
        void upload(T* data);
        
        /**
         * Downloads data from gpu memory to cpu memory. Using "pinned memory"
         * will give best performance.
         */
        void download(T* data);
        
        int getRows();
        int getCols();
        
        /**
         * Prints out the contents of the matrix m.
         */
        template <typename U> 
        friend std::ostream& operator<< (std::ostream& os, const GpuMatrix<U>& m);
        
        private:
            T* h_ptr;
            T* d_ptr;
            int rows;
            int cols;
            int pitch;
                   
    };
    
}

#include "GoTools/implicitization/GpuMatrix_impl.hpp"

#endif /*GPUMATRIX_H_*/
