//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _IGESLIB-DOXYMAIN_H
#define _IGESLIB-DOXYMAIN_H


/**
\page igeslib GoTools Igeslib

The \beginlink \link Go::IGESconverter IGES converter \endlink
read an IGES file and represents its entites in the 
internal data structure of GoTools. It can also write a model represented in
GoTools to an IGES file or convert between an IGES file and the 
\beginlink \link streamable_doc internal file format \endlink of GoTools.

GoTools represent only geometric entities. Thus, IGES entities like annotation,
structure, property, associativity, view, drawing 
and figure will be neglected. Neither are constructive solid geometry or
finite element modelling entites handled. If such entities exist in a file
read by the IGES converter, warning messages will be issued.

The topological entities specified in IGES 5.3 is not handled by the current
version of the IGES converter. Thus, the entities vertex, edge, edge list,
loop, face and shell is not handled. However, the geometric entities 
corresponding to these topological entities will be read. Colour information
is read.

The content of an IGES file is transferred to the application as a vector
of \beginlink \link Go::GeomObject GeomObjects\endlink.
By checking the type of each 
object and acting thereafter, the model can be stored and handled in 
the GoTools environment.

To write an IGES file, the file entities are added one by one to the IGES
convertor using the function addGeom which takes a GeomObject as parameter.
The actual file is written by the command writeIGES.

*/

#endif // _IGESLIB-DOXYMAIN_H
