//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include <stdexcept>
#include <math.h>
#include <cstdlib>
#include "GoTools/utils/randomnoise.h"

using namespace std;

namespace Go {

//===========================================================================
void normalNoise(double* res, double mean_err, int num_samples)
//===========================================================================
{
    double scale_factor = double(2) / double(RAND_MAX);
    double v1, v2, r2, fact;
    for (int i = 0; i < num_samples; i+=2) {
	do {
	    v1 = double(rand()) * scale_factor - 1;
	    v2 = double(rand()) * scale_factor - 1;
	    r2 = v1 * v1 + v2 * v2;
	} while (r2 > 1 || r2 == double(0) || false);
	// we now know that the point (v1, v2) is within the unit circle, away from 0
	fact = sqrt(- 2 * log(r2)/r2);
	fact *= mean_err;
	res[i] = v1 * fact;
	if (i+1 < num_samples) {
	    res[i+1] = v2 * fact;
	}
    }
}

//===========================================================================
void uniformNoise(double* res, double lval, double uval, int num_samples)
//===========================================================================
{
    if (uval <= lval) {
	throw runtime_error("uniformNoise(...) : erroneous range.");
    }
    double range = uval - lval;
    double scale_factor = range / double(RAND_MAX);
    for (int i = 0; i < num_samples; ++i) {
	res[i] = double(rand()) * scale_factor + lval;
    }
}
 
}; // namespace Go
