//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/geometry/ClosestPoint.h"

namespace Go {

//===========================================================================
void  ClosestPoint::closestPtSurfSurfPlane(const std::vector<Point>& epoint,
			    const std::vector<Point>& epnt1,
			    const std::vector<Point>& epnt2,
			    const Point& epar1,
			    const Point& epar2,
			    const ParamSurface* psurf1,
			    const ParamSurface* psurf2,
			    double aepsge,
			    std::vector<Point>& gpnt1,
			    std::vector<Point>& gpnt2,
			    Point& gpar1, 
			    Point& gpar2, 
			    int& jstat,
			    AlgorithmChoice algo)
//===========================================================================
{
    if (algo == GEOMETRICAL) {
	ClosestPoint::closestPtSurfSurfPlaneGeometrical(epoint, 
					  epnt1, 
					  epnt2, 
					  epar1, 
					  epar2, 
					  psurf1, 
					  psurf2, 
					  aepsge, 
					  gpnt1, 
					  gpnt2, 
					  gpar1, 
					  gpar2, 
					  jstat);
    } else {
	// algo == FUNCTIONAL
	ClosestPoint::closestPtSurfSurfPlaneFunctional(epoint, 
					  epnt1, 
					  epnt2, 
					  epar1, 
					  epar2, 
					  psurf1, 
					  psurf2, 
					  aepsge, 
					  gpnt1, 
					  gpnt2, 
					  gpar1, 
					  gpar2, 
					  jstat);
    }
}

}; // end namespace Go;

