//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/geometry/RectGrid.h"
#include "GoTools/geometry/SplineUtils.h"

using namespace std;

namespace Go
{

//===========================================================================
RectGrid::~RectGrid()

//===========================================================================
{
}

//===========================================================================
void RectGrid::read (std::istream& is)
//===========================================================================
{
    // Canonical data
    is >> dim_;
    is >> numu_;
    is >> numv_;
    int n = numu_*numv_*dim_;
    points_.resize(n);
    for (int i = 0; i < n; ++i) {
	is >> points_[i];
    }
}

//===========================================================================
void RectGrid::write (std::ostream& os) const
//===========================================================================
{
    streamsize prev = os.precision(15);

    os << dim_ << ' ' << numu_ << ' ' << numv_ << '\n';
    int n = numu_*numv_;
    for (int i = 0; i < n; ++i) {
	os << points_[i*dim_];
	for (int d = 1; d < dim_; ++d) {
	    os << ' ' << points_[i*dim_ + d];
	}
	os << '\n';
    }
    os << endl;
    os.precision(prev);   // Reset precision to it's previous value
}

//===========================================================================
BoundingBox RectGrid::boundingBox() const
//===========================================================================
{
    BoundingBox box;
    box.setFromArray(&points_[0], &points_[0] + points_.size(), dim_);
    return box;
}

//===========================================================================
int RectGrid::dimension() const
//===========================================================================
{
    return dim_;
}

//===========================================================================
ClassType RectGrid::instanceType() const
//===========================================================================
{
    return classType();
}

//===========================================================================
void RectGrid::swapDirections() 
//===========================================================================
{
    SplineUtils::transpose_array(dim_, numv_, numu_, &points_[0]);
    swap(numu_, numv_);
}

} // namespace Go
