//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/geometry/PointOnCurve.h"

using namespace Go;
using std::vector;

//===========================================================================
PointOnCurve::PointOnCurve()
//===========================================================================
{
  t1_ = t2_ = par_ = 0.0;
}

//===========================================================================
PointOnCurve::PointOnCurve(shared_ptr<ParamCurve> curve, double par)
    : par_(par), crv_(curve)
//===========================================================================
{
    t1_ = crv_->startparam();
    t2_ = crv_->endparam();

    point_ = crv_->point(par_);
}

//===========================================================================
PointOnCurve::PointOnCurve(shared_ptr<ParamCurve> curve, Point pnt)
    : point_(pnt), crv_(curve)
//===========================================================================
{

    t1_ = crv_->startparam();
    t2_ = crv_->endparam();

    double clo_dist;
    Point clo_pt;
    crv_->closestPoint(point_, t1_, t2_, par_, clo_pt, clo_dist);
}

//===========================================================================
PointOnCurve::~PointOnCurve()
//===========================================================================
{
}

//===========================================================================
Point PointOnCurve::getPos() const 
//===========================================================================
{
    return point_;
}

//===========================================================================
void PointOnCurve::evaluate(int der, std::vector<Point>& deriv) const
//===========================================================================
{
  if (crv_.get())
    crv_->point(deriv, par_, der);
}

//===========================================================================
void PointOnCurve::setParInterval(double start, double end)
//===========================================================================
{
    ASSERT(start <= par_ && par_ <= end);
    t1_ = start;
    t2_ = end;
}


