//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/geometry/ObjectHeader.h"
#include "GoTools/geometry/Utils.h"

namespace Go
{

//===========================================================================
ObjectHeader::~ObjectHeader()
//===========================================================================
{
}   

//===========================================================================
void ObjectHeader::read (std::istream& is)
//===========================================================================
{
    // We should verify that the object is valid.
    bool is_good = is.good();
    if (!is_good) {
	THROW("Invalid object header!");
    }
    int dummy;
    is >> dummy;
    class_type_ = static_cast<ClassType>(dummy);
    is >> major_version_;
    is >> minor_version_;
    int auxsize;
    is >> auxsize;
    is_good = is.good();
    if (!is_good) {
	THROW("Invalid object header!");
    }
    auxillary_data_.resize(auxsize);
    for (int i = 0; i < auxsize; ++i) {
	is >> auxillary_data_[i];
    }
}   

//===========================================================================
void ObjectHeader::write (std::ostream& os) const
//===========================================================================
{
    os << class_type_ << ' ';
    os << major_version_ << ' ';
    os << minor_version_ << ' ';
    os << auxillary_data_.size();
    for (size_t i = 0; i < auxillary_data_.size(); ++i) {
	os << ' ' << auxillary_data_[i];
    }
    os << '\n' << std::endl;
    
}

} // namespace Go
