//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include <GoTools/geometry/GoTools.h>
#include "GoTools/geometry/Factory.h"

using std::string;

namespace Go {

GoTools::GoTools()
{
    // TODO Auto-generated constructor stub
}

GoTools::~GoTools()
{
    // TODO Auto-generated destructor stub
}

void GoTools::init()
{
    Registrator<SplineCurve> r100;
    Registrator<CurveOnSurface> r110;
    Registrator<Line> r120;
    Registrator<Circle> r130;
    Registrator<Ellipse> r140;
    Registrator<BoundedCurve> r150;
    Registrator<Hyperbola> r160;
    Registrator<Parabola> r170;

    Registrator<SplineSurface> r200;
    Registrator<BoundedSurface> r210;
    Registrator<CompositeSurface> r240;
    Registrator<Plane> r250;
    Registrator<Cylinder> r260;
    Registrator<Sphere> r270;
    Registrator<Cone> r280;
    Registrator<Torus> r290;
    Registrator<SurfaceOfRevolution> r291;
    Registrator<Disc> r292;

    Registrator<PointCloud<2> > r400_2d;
    Registrator<PointCloud<3> > r400_3d;
    Registrator<LineCloud> r410;

    Registrator<RectGrid> r510;

}

string GoTools::className(ClassType class_type)
{
    switch (class_type) {
    case Class_SplineCurve:
        return "SplineCurve";
    case Class_CurveOnSurface:
        return "CurveOnSurface";
    case Class_Line:
        return "Line";
    case Class_Circle:
        return "Circle";
    case Class_Ellipse:
        return "Ellipse";
    case Class_BoundedCurve:
        return "BoundedCurve";
    case Class_Hyperbola:
        return "Hyperbola";
    case Class_Parabola:
        return "Parabola";

    case Class_SplineSurface:
        return "SplineSurface";
    case Class_BoundedSurface:
        return "BoundedSurface";
    case Class_CompositeSurface:
        return "CompositeSurface";
    case Class_Plane:
        return "Plane";
    case Class_Cylinder:
        return "Cylinder";
    case Class_Sphere:
        return "Sphere";
    case Class_Cone:
        return "Cone";
    case Class_Torus:
        return "Torus";
    case Class_SurfaceOfRevolution:
        return "SurfaceOfRevolution";
    case Class_Disc:
        return "Disc";
    case Class_LRSplineSurface:
        return "LRSplineSurface";
    case Class_TSplineSurface:
        return "TSplineSurface";

    case Class_PointCloud:
        return "PointCloud";
    case Class_LineCloud:
        return "LineCloud";

    case Class_RectGrid:
        return "RectGrid";

    default:
        return "Unknown";
    }
}


double GoTools::spaceEpsilon()
{
    return space_epsilon_;
}


void GoTools::setSpaceEpsilon(double space_epsilon)
{
    space_epsilon_ = space_epsilon;
}


double GoTools::parameterEpsilon()
{
    return parameter_epsilon_;
}


void GoTools::setParameterEpsilon(double parameter_epsilon)
{
    parameter_epsilon_ = parameter_epsilon;
}


// Set default tolerances
double GoTools::space_epsilon_ = 0.001;
double GoTools::parameter_epsilon_ = 0.001;


} // namespace Go
