//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/creators/EvalParamCurve.h"
#include "GoTools/geometry/ParamCurve.h"
#include "GoTools/geometry/CurveOnSurface.h"
#include "GoTools/geometry/ParamSurface.h"

#include <fstream>

using namespace std;
using namespace Go;

//===========================================================================
EvalParamCurve::EvalParamCurve(shared_ptr<Go::ParamCurve>& crv)
    : crv_(crv)
//===========================================================================
{
}


//===========================================================================
EvalParamCurve::~EvalParamCurve()
//===========================================================================
{
}


//===========================================================================
Point EvalParamCurve::eval(double t) const
//===========================================================================
{
    return crv_->ParamCurve::point(t);
}


//===========================================================================
void EvalParamCurve::eval(double t, int n, Point der[]) const
//===========================================================================
{
  vector<Point> pts(n);
  crv_->point(pts, t, n);
  for (int ki=0; ki<n; ++ki)
    der[ki] = pts[ki];
}


//===========================================================================
double EvalParamCurve::start() const
//===========================================================================
{
  return crv_->startparam();
}


//===========================================================================
double EvalParamCurve::end() const
//===========================================================================
{
  return crv_->endparam();
}


//===========================================================================
int EvalParamCurve::dim() const
//===========================================================================
{
  return crv_->dimension(); 
}


//===========================================================================
bool EvalParamCurve::approximationOK(double par, Point approxpos,
				  double tol1, double tol2) const
//===========================================================================
{
    // Only first tolerance is used.
  Point pos = eval(par);

  double dist = pos.dist(approxpos); // Both points are in space.

  return (dist < tol1);
}

void EvalParamCurve::write(std::ostream& out) const
{
  crv_->writeStandardHeader(out);
  crv_->write(out);
  shared_ptr<CurveOnSurface> sf_cv = 
    dynamic_pointer_cast<CurveOnSurface,ParamCurve>(crv_);
  if (sf_cv.get())
    {
      sf_cv->underlyingSurface()->writeStandardHeader(out);
      sf_cv->underlyingSurface()->write(out);
    }
  }
