//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _CONFIG_H
#define _CONFIG_H

#ifdef __BORLANDC__
# define GO_API __declspec(package)
#elif defined(MICROSOFT) || defined(_MSC_VER)
# if defined(__DLL__) || defined(_DLL)
#  define GO_API __declspec(dllexport)
# else
#  define GO_API __declspec(dllimport)
# endif // __DLL__
#else
# define GO_API
#endif // __BORLANDC__

// The following pragma is not optimal, but it's a workaround to
// getting rid of warning C4251 in Visual Studio
#ifdef _MSC_VER
#pragma warning( disable: 4251 )
#endif // _MSC_VER

#ifdef USE_BOOST
#include <boost/shared_ptr.hpp>
using boost::shared_ptr;
using boost::dynamic_pointer_cast;
using boost::const_pointer_cast;
using boost::static_pointer_cast;
#include <boost/static_assert.hpp>
#define static_assert(x, msg) BOOST_STATIC_ASSERT(x)
#include <boost/type_traits.hpp>
using boost::is_floating_point;
#else
#include <memory>
using std::shared_ptr;
using std::dynamic_pointer_cast;
using std::const_pointer_cast;
using std::static_pointer_cast;
#include <type_traits>
using std::is_floating_point;
#endif

#endif // _CONFIG_H
