//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _TESSELATORUTILS_H
#define _TESSELATORUTILS_H


#include "GoTools/geometry/ParamSurface.h"
#include "GoTools/geometry/LineCloud.h"

namespace Go {

/// Related to the relative resolution of tesselation
namespace TesselatorUtils
{
  /// Get the mesh size of a surface in the two parameter directions
  /// given the total number of nodes in the mesh. NB! u_nmb*v_nmb
  /// are probably not exactly equal to uv_nmb
  void getResolution(const ParamSurface *surf, 
		     int& u_nmb, int& v_nmb, int uv_nmb = 400);

  /// Fetch the control polygon of some geometric entity
  shared_ptr<LineCloud> getCtrPol(GeomObject* obj);

}  // of namespace TesselatorUtils
}; // end namespace Go
#endif // _TESSELATORUTILS_H
