//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _RECTGRIDTESSELATOR_H
#define _RECTGRIDTESSELATOR_H


#include "GoTools/tesselator/Tesselator.h"
#include "GoTools/geometry/RectGrid.h"
#include "GoTools/tesselator/QuadMesh.h"
#include <memory>

namespace Go
{

    /** Transfer the information in a RectGrid to a QuadMesh
     */

class GO_API RectGridTesselator : public Tesselator
{
public:
  /// Constructor
  RectGridTesselator(const RectGrid& rg);
    
  /// Destructor
    virtual ~RectGridTesselator();
  
    virtual void tesselate();

    /// Fetch result
    shared_ptr<QuadMesh> getMesh()
    {
	return quadmesh_;
    }

private:
    const RectGrid& rectgrid_;
    shared_ptr<QuadMesh> quadmesh_;
};

} // namespace Go


#endif // _RECTGRIDTESSELATOR_H

