//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _GENERALMESH_H
#define _GENERALMESH_H

#include "GoTools/utils/config.h"

namespace Go
{

class RegularMesh;
 class LineStrip;
 class GenericTriMesh;

/** Super class for meshes. Used in transfer of mesh.
*/


class GO_API GeneralMesh
{
public:
  /// Destructor
    virtual ~GeneralMesh();

    /// Number of nodes in mesh
    virtual int numVertices() = 0;

    /// Fetch all nodes 
    virtual double* vertexArray() = 0;

    /// Fetch parameter values corresponding to the nodes
    virtual double* paramArray() = 0;

    /// Check if a given node lies at the boundary
    virtual int atBoundary(int idx) = 0;
    
    /// The number of triangles represented by this mesh
    virtual int numTriangles()
    {
      return 0;
    }

    /// Indices of nodes belonging to each triangle
    virtual unsigned int* triangleIndexArray() = 0;

    /// Casting. Return as regular mesh if possible
    virtual RegularMesh* asRegularMesh();

    /// Casting. Return as line strip if possible
    virtual LineStrip* asLineStrip();

    /// Casting. Return as generic tri mesh if possible
    virtual GenericTriMesh* asGenericTriMesh();

};

} // namespace Go




#endif // _GENERALMESH_H
