//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _EXAMPLES_DOXYMAIN_H
#define _EXAMPLES_DOXYMAIN_H

/**
\page gotools_examples GoTools example files

A number of example programs are created to illustrate the use of various
GoTools functionality.

Example programs in gotools-core:
- \ref adapt_curve
- \ref append_curve
- \ref approx_curve
- \ref approx_surface
- \ref circle
- \ref closestpoint_curve
- \ref closestpoint_degenerate_sf
- \ref closestpoint_surface
- \ref cone
- \ref const_param_curves
- \ref coons_patch_gen
- \ref cylinder
- \ref ellipse
- \ref interpol_curve_free
- \ref interpol_curve_hermite
- \ref linear_swept_surface
- \ref project_curve
- \ref rotational_swept_surface
- \ref sphere
- \ref surface_of_revolution
- \ref torus

The module trivariate has the following example programs:
- \ref coons_patch_volume_gen
- \ref createCoonsVolume
- \ref linear_swept_volume
- \ref loft_volume_creator
- \ref rotational_swept_volume

The example programs related to compositemodel:
- \ref createSplitDisc
- \ref createBlockStructuredDisc
- \ref createVolumeBoundaries
- \ref face2splineset

The example programs in the trivariatemodel module are:
- \ref createMidShip
- \ref mirrorAndLoft
- \ref multiPatchSweep

*/

#endif // _EXAMPLES_DOXYMAIN_H
