//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _INTERPOLATOR_H
#define _INTERPOLATOR_H

#include <vector>
#include "GoTools/utils/config.h"

namespace Go
{

class BsplineBasis;

/// Base class for spline interpolators or approximators
class GO_API Interpolator
{
public:
    /// virtual desctructor assures safe inheritance
    virtual ~Interpolator();

    /// Interpolate or approximate a set of point data by a spline
    /// \param num_points the number of data points to approximate
    /// \param dimension the dimension of each data point
    /// \param param_start pointer to the array where the points' parameters
    ///                    are consecutively stored
    /// \param data_start pointer to the array where the points are consecutively
    ///                   stored
    /// \param coefs upon function completion, this vector will contain the 
    ///              control points of the interpolating (or approximating spline).
    ///              (In order to get access to the associated BsplineBasis, use
    ///              the function \ref basis().
    virtual void interpolate(int num_points,
			     int dimension,
			     const double* param_start,
			     const double* data_start,
			     std::vector<double>& coefs) = 0;
    
    /// after the function \ref interpolate() has been successfully run, this
    /// function can be called to get the BsplineBasis of the generated curve.
    /// \return a constant reference to the BsplineBasis of the curve previously 
    ///         generated by \ref interpolate().
    virtual const BsplineBasis& basis() = 0;
};

}

#endif // _INTERPOLATOR_H

