//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _ELEMENTARYCURVE_H
#define _ELEMENTARYCURVE_H


#include "GoTools/geometry/ParamCurve.h"
#include "GoTools/geometry/SplineCurve.h"


namespace Go {


/// \brief ElementaryCurve is a base class for elementary curves like
/// lines and circles. Such curves have natural parametrizations and
/// ElementaryCurve is therefore a subclass of ParamCurve.
class ElementaryCurve : public ParamCurve
{
public:
    ElementaryCurve();

    /// Virtual destructor, enables safe inheritance.
    virtual ~ElementaryCurve();

    // --- Functions inherited from GeomObject ---
    virtual ElementaryCurve* clone() const = 0;

    // --- Functions inherited from ParamCurve ---
    virtual void reverseParameterDirection(bool switchparam = false);

    // --- Functions specific to ElementaryCurve ---
    virtual SplineCurve* createSplineCurve() const = 0;

    /// Set bounds for the parametrization of the curve
    /// \param startpar start parameter
    /// \param endpar end parameter
    virtual void setParamBounds(double startpar, double endpar) = 0;

    // Translate the curve along a given vector
    virtual void translateCurve(const Point& dir) = 0;

    virtual bool isReversed() const;

    // Helper function for reverseParameterDirection() when switchparam
    // is true. Used when curve is a parameter curve and x and y coordinates
    // should be swapped.
    virtual void swapParameters2D() = 0;

protected:
    // Returns reversed parameter in [tmin, tmax] if isReversed_ is true
    void getReversedParameter(double& t) const;

    bool isReversed_;
};


} // namespace Go


#endif // _ELEMENTARYCURVE_H

