//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/compositemodel/ftPlane.h"
#include "GoTools/utils/BoundingBox.h"


namespace Go
{


  //===========================================================================
  ftPlane::ftPlane(const ftPlane& plane)
    :normal_(plane.normal_), point_(plane.point_)
  //===========================================================================
  {
  }

  // A plane intersects a box if it separates its corners
  //===========================================================================
  bool ftPlane::intersectsBox(const BoundingBox& box) const
  //===========================================================================
  {
    Point corner[2];
    corner[0] = box.low() - point_;
    corner[1] = box.high() - point_;
    double firstNorm = corner[0]*normal_;
    if (firstNorm * (corner[1]*normal_) <= 0) return true;
    for (int i = 1; i < 7; ++i)
      if (firstNorm * (Point(corner[i>>2][0],
			     corner[(i>>1)&1][1],
			     corner[i&1][2])
		       *normal_)
	  <= 0)
	return true;
    return false;
  }

} // namespace Go
