//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/compositemodel/ftFaceBase.h"


namespace Go
{

//===========================================================================
ftFaceBase::ftFaceBase()
//===========================================================================
{
    id_ = -1;
    //is_turned_ = false;
}

//===========================================================================
ftFaceBase::ftFaceBase(int id/*, bool is_turned*/)
//===========================================================================
{
    id_ = id;
    //is_turned_ = is_turned;
}

//===========================================================================
ftFaceBase::~ftFaceBase()
//===========================================================================
{
}


//===========================================================================
ftSurface* ftFaceBase::asFtSurface()
{
  return 0;
}
//===========================================================================


//===========================================================================
void ftFaceBase::setId(int id)
//===========================================================================
{
    id_ = id;
}

//===========================================================================
int ftFaceBase::getId()
//===========================================================================
{
    return id_;
}

// //---------------------------------------------------------------------------
// void ftFaceBase::turnFace(vector<ftFaceBase*>& turned)
// //---------------------------------------------------------------------------
// {
//   int ki;
//   for (ki=0; ki<(int)turned.size(); ki++)
//     if (turned[ki] == this)
//       return;   // This face is already turned.

//   //  std::cout << "Turning face: " << this << std::endl;
//   turnOrientation();  // Turn the current face
//   turned.push_back(this);

//   // Reverse the direction of all edges, and turn neighbouring surfaces.
//   vector<shared_ptr<ftEdgeBase> > start_edges = startEdges();
//   for (ki=0; ki<(int)start_edges.size(); ki++)
//     {
//       ftEdgeBase *e0 = start_edges[ki].get();
//       bool finished = false;
//       while (!finished)
// 	{
// 	  e0->turnOrientation();
// 	  if (e0->twin())
// 	    e0->twin()->face()->turnFace(turned);
// 	  e0 = e0->next();
// 	  if (e0 == start_edges[ki].get())
// 	    finished = true;
// 	}
//     }
// }

//---------------------------------------------------------------------------
void ftFaceBase::updateBoundaryLoops(shared_ptr<ftEdgeBase> new_edge)
//---------------------------------------------------------------------------
{
    // Nothing to do
}


} // namespace Go
