//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/compositemodel/cmUtils.h"
#include "GoTools/compositemodel/ftEdgeBase.h"
#include "GoTools/geometry/BoundedSurface.h"
#include "GoTools/geometry/GeometryTools.h"


using std::vector;


namespace Go
{

//===========================================================================
double cmUtils::estimatedCurveLength(ftEdgeBase* edge, int nmb_samples)
//===========================================================================
{
    ALWAYS_ERROR_IF(nmb_samples < 2,
		"At least 2 points needed to estimate curve length!");

    double total_length = 0.0;
    double tmin = edge->tMin();
    double tmax = edge->tMax();
    double step = (tmax - tmin) / (nmb_samples - 1);
    Point curr_pt = edge->point(tmin);
    Point next_pt = edge->point(tmin + step);
    total_length += (next_pt - curr_pt).length();
    for (int i = 1; i < nmb_samples - 1; ++i) {
	curr_pt = next_pt;
	next_pt = edge->point(tmin + i*step);
	total_length += (next_pt - curr_pt).length();
    }

    return total_length;
}

//===========================================================================
RectDomain cmUtils::geometricParamDomain(ParamSurface* sf)
//===========================================================================
{
  double len_u, len_v;
  GeometryTools::estimateSurfaceSize(*sf, len_u, len_v);

  RectDomain domain = sf->containingDomain();

  double u_from = domain.umin();
  double u_to = u_from + len_u;
  double v_from = domain.vmin();
  double v_to = v_from + len_v;
  
  Vector2D ll(u_from, v_from);
  Vector2D ur(u_to, v_to);
  
  return RectDomain(ll, ur);
}

} // namespace Go
