//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#include "GoTools/compositemodel/IntResultsSfModel.h"
#include "GoTools/geometry/ParamCurve.h"
#include "GoTools/tesselator/LineStrip.h"

using namespace std;

namespace Go
{
  //===========================================================================
  // Constructor
  IntResultsSfModel::IntResultsSfModel(SurfaceModel* sfmodel, const ftLine& line)
  //===========================================================================
    : IntResultsModel(SurfaceModel_Line), sfmodel1_(sfmodel)
  {
    addLineInfo(line);
  }

  //===========================================================================
  // Constructor
  IntResultsSfModel::IntResultsSfModel(SurfaceModel* sfmodel, const ftPlane& plane)
  //===========================================================================
    : IntResultsModel(SurfaceModel_Plane), sfmodel1_(sfmodel)
  {
    addPlaneInfo(plane);
  }

  //===========================================================================
  // Destructor
  IntResultsSfModel::~IntResultsSfModel()
  //===========================================================================
  {
  }

  //===========================================================================
  void IntResultsSfModel::addIntPts(vector<ftPoint>& intpts)
  //===========================================================================
  {
    int_pts_.insert(int_pts_.end(), intpts.begin(), intpts.end());
  }


  //===========================================================================
  void IntResultsSfModel::addIntCvs(ftCurve& cvs)
  //===========================================================================
  {
    intcvs_ = cvs;
  }

  //===========================================================================
  void IntResultsSfModel::tesselate(std::vector<shared_ptr<LineStrip> >& meshes,
				    PointCloud3D& points) const
  //===========================================================================
  {
    if (hasIntCurves())
      intcvs_.tesselate(meshes);
    
    vector<double> coords;
    for (size_t ki=0; ki<int_pts_.size(); ++ki)
      {
	const Point pt = int_pts_[ki].position();
	coords.insert(coords.end(), pt.begin(), pt.end());
      }

    points = PointCloud3D(&coords[0], (int)int_pts_.size());
  }

  //===========================================================================
  void IntResultsSfModel::tesselate(int resolution, 
				    std::vector<shared_ptr<LineStrip> >& meshes,
				    PointCloud3D& points) const
  //===========================================================================
  {
    if (hasIntCurves())
      intcvs_.tesselate(resolution, meshes);
    
    vector<double> coords;
    for (size_t ki=0; ki<int_pts_.size(); ++ki)
      {
	const Point pt = int_pts_[ki].position();
	coords.insert(coords.end(), pt.begin(), pt.end());
      }

    points = PointCloud3D(&coords[0], (int)int_pts_.size());
  }

  //===========================================================================
  void IntResultsSfModel::tesselate(double density, 
				    std::vector<shared_ptr<LineStrip> >& meshes,
				    PointCloud3D& points) const
  //===========================================================================
  {
    if (hasIntCurves())
      intcvs_.tesselate(density, meshes);
    
    vector<double> coords;
    for (size_t ki=0; ki<int_pts_.size(); ++ki)
      {
	const Point pt = int_pts_[ki].position();
	coords.insert(coords.end(), pt.begin(), pt.end());
      }

    points = PointCloud3D(&coords[0], (int)int_pts_.size());
  }

} // namespace Go
