//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _FTPOINT_H
#define _FTPOINT_H


#include "GoTools/utils/Point.h"

namespace Go
{

class ftSurface;

//===========================================================================
/** ftPoint - represents a point, possibly lying on a surface
 * ftPoint contains representations for both a 3D point in space
 * and possibly also parameters for the point on a specific surface.
 *
 * \author Atgeirr F Rasmussen <atgeirr@sintef.no>
 */
//===========================================================================
class ftPoint
{
protected:
    Point pt_;              // The point
    ftSurface* surface_;         // The surface on which it lies (if nonzero)
    double u_, v_;            // Coordinates on that surface

public:
    /// Constructor
    /// \param pt Point
    /// \param sf Associated surface
    /// \param u First parameter in surface corresponding to point
    /// \param v Second parameter in surface corresponding to point
    ftPoint(Point pt, ftSurface* sf = 0, double u = 0, double v = 0)
	: pt_(pt), surface_(sf), u_(u), v_(v) {}
    /// Constructor. Point in 3d given by space coordinates
    ftPoint(double x, double y, double z)
	: pt_(x, y, z), surface_(0), u_(0), v_(0) {}
    /// Position of point
    const Point& position() const { return pt_; }
    /// Associated face/surface
    ftSurface* face() const { return surface_; }
    /// 1. parameter in surface
    double u() const { return u_; }
    /// 2. parameter in surface
    double v() const { return v_; }
    /// Normal of surface in point
    Point normal() const;
};

} // namespace Go


#endif // _FTPOINT_H

