//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _FTPLANE_H
#define _FTPLANE_H

#include "GoTools/utils/Point.h"

namespace Go
{
    class BoundingBox;


//===========================================================================
/** ftPlane -  Representing a plane
 * 
 *
 * \author Atgeirr F Rasmussen <atgeirr@sintef.no>
 * 
 * 
 */
//===========================================================================

class ftPlane
{
private:

protected:

    Point normal_;  
    Point point_;

public:

    ftPlane()
      {}

    /// Constructor.
    /// First parameter is a vector normal to the plane,
    /// second parameter is a point in the plane.
    ftPlane(const Point& n, const Point& p)
	: normal_(n), point_(p)
	{}


    /// Constructor.
    /// Parameters are three points in the plane
    ftPlane(const Point& x, const Point& y, const Point& z)
      : point_(x)
    {
      normal_ = (z-x) % (y-x);
      normal_ /= normal_.length();
    }

    /// Copy constructor
    ftPlane(const ftPlane& plane);

    /// Destructor.
    ~ftPlane() {}

    /// Get plane normal
    const Point& normal() const { return normal_; }
    /// Get point in plane
    const Point& point()  const { return point_;  }
    /// Check if the plane intersects a bounding box
    bool intersectsBox(const BoundingBox& box) const;
};

} // namespace Go


#endif // _FTPLANE_H

