//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _COMPOSITEMODEL_DOXYMAIN_H
#define _COMPOSITEMODEL_DOXYMAIN_H

//===========================================================================
//                        DOCUMENTATION ON MAIN PAGE
//===========================================================================

/// \page compositemodel GoTools CompositeModel
///
/// Contains tools for representing composite models.
///
/// \if null
/// An overview documentation for this module can be found in
/// \ref compositemodel_doc.
/// \endif
///  
/// This module depends on the following GoTools modules:
/// - GoTools Core
/// - GoTools Implicitization
/// - GoTools Intersection
/// - GoTools Parametrization
/// - GoTools Igeslib
/// - GoTools Topology
///
/// and the following modules external to GoTools:
/// - SISL (SINTEF)
/// - TTL (SINTEF)
/// - The newmat matrix library, which is freely available from <a
/// href ="http://www.robertnz.net/">www.robertnz.net</a>.
///
/// SISL, TTL and newmat is included for convenience.

// /// \namespace Go
// /// The Go namespace is the common namespace for all GoTools modules.

// /// \namespace hetriang
// /// Namespace for classes in the half-edge data structure.

#endif // _COMPOSITEMODEL_DOXYMAIN_H
