//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __CMUTILS_H
#define __CMUTILS_H


#include "GoTools/compositemodel/ftFaceBase.h"


namespace Go
{

  class ParamSurface;

  /// Various utility functions for the compositemodel module
namespace cmUtils
{

  // Return 2-dimensional point representing parameter values of input point.
  // Point faceParameter(ftEdgeBase* edge, double t);

  /// Estimate the curve length corresponding to an edge
  double estimatedCurveLength(ftEdgeBase* edge, int nmb_samples = 4);

  /// Domain of surface is rescaled according to surface lengths in geometry space.
  RectDomain geometricParamDomain(ParamSurface* sf);


}    // Namespace cmUtils

} // namespace Go

#endif    // #ifndef __CMUTILS_H
