//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef __SPLITMODELUTILS_H
#define __SPLITMODELUTILS_H

#include "GoTools/compositemodel/SurfaceModel.h"

namespace Go
{
  /// Utility functionality for splitting of surface models. 
  namespace SplitModelUtils
  {
    /// The model is split from corners vertices belonging only to one face
    /// towards the axis defined by pnt and axis
    void splitInFreeCorners(shared_ptr<SurfaceModel> sfmodel,
			    const Point& pnt, const Point& axis);

    /// The model is split from vertices that do not constitute a corner for the
    /// current face towards the axis defined by pnt and axis
     void splitInNonCorners(shared_ptr<SurfaceModel> sfmodel,
			    const Point& pnt, const Point& axis);

     /// The model is split from vertices in outer loops towards the axis 
     /// defined by pnt and axis or towards vertices in inner loops
     void splitInOuterVertices(shared_ptr<SurfaceModel> sfmodel,
			       shared_ptr<ftSurface> face,
			       const Point& pnt, const Point& axis);
  }
}

#endif    // #ifndef __SPLITMODELUTILS_H
