//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _POINTONEDGE
#define _POINTONEDGE


#include "GoTools/utils/Point.h"

namespace Go
{

class ftEdge;

//===========================================================================
/** PointOnEdge - represents a point lying on an edge. Storage.
 * 
 */
//===========================================================================
class PointOnEdge
{

 public:
  /// Constructor
  /// \param the edge on which the point lies
  /// \param par associated edge parameter
  PointOnEdge(ftEdge* edge, double par);

  /// Destructor
  ~PointOnEdge();
	
  /// Point position
  const Point& position() const { return pt_; }
  /// Associated edge
  ftEdge* edge() const { return edge_; }
  /// Associated edge parameter
  double par() const { return par_; }
    
 private:
  ftEdge* edge_;
  double par_;
  Point pt_;
};

} // namespace Go


#endif // _POINTONEDGE_H

