//===========================================================================
// Copyright (C) 1998, 2000-2007, 2010, 2011, 2012, 2013 SINTEF ICT,
// Applied Mathematics, Norway.
//
// This file is part of GoTools
//
// This program is free software; you can redistribute it and/or          
// modify it under the terms of the GNU General Public License            
// as published by the Free Software Foundation version 2 of the License. 
//
// This program is distributed in the hope that it will be useful,        
// but WITHOUT ANY WARRANTY; without even the implied warranty of         
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          
// GNU General Public License for more details.                           
//
// You should have received a copy of the GNU General Public License      
// along with this program; if not, see <http://www.gnu.org/licenses>
//
// Contact information: E-mail: tor.dokken@sintef.no                      
// SINTEF ICT, Department of Applied Mathematics,                         
// P.O. Box 124 Blindern,                                                 
// 0314 Oslo, Norway.                                                     
//
// Other licenses are also available for this software, notably licenses
// for:
// - Building commercial software.                                        
// - Building software whose source code you wish to keep private.        
//===========================================================================

#ifndef _PATH_H
#define _PATH_H

#include "GoTools/compositemodel/Vertex.h"
#include "GoTools/compositemodel/ftEdge.h"
#include <vector>


namespace Go
{
  /// Functions related to sequence of edges
  namespace Path
  {
    /// Estimate mid point, normal and radius defined by an edge
    /// sequence
    bool estimateHoleInfo(std::vector<ftEdge*> edges, Point& centre, 
			  Point& axis, double& radius);

    /// Identify a loops starting and ending in a given vertex in an ordered
    /// sequence of edges
    std::vector<ftEdge*> identifyLoop(std::vector<ftEdge*> edges, 
				      shared_ptr<Vertex> vx);

  }  // namespace Patch

}  // namespace Go


#endif // _PATH_H
